// 
// Decompiled by Procyon v0.5.36
// 

package ORG.oclc.oai.harvester.crosswalk;

import java.util.StringTokenizer;
import java.util.Iterator;
import java.lang.reflect.Constructor;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;
import java.util.Map;

public class Crosswalks
{
    private Map crosswalksMap;
    
    public Crosswalks(final Properties properties) {
        this.crosswalksMap = new HashMap();
        final String propertyPrefix = "Crosswalks.";
        final Enumeration enum1 = properties.propertyNames();
        while (enum1.hasMoreElements()) {
            final String propertyName = enum1.nextElement();
            if (propertyName.startsWith(propertyPrefix)) {
                final String schemaLabel = propertyName.substring(propertyPrefix.length());
                final String formatClassName = (String)properties.get(propertyName);
                try {
                    final Class crosswalkClass = Class.forName(formatClassName);
                    final Constructor crosswalkConstructor = crosswalkClass.getConstructor(Properties.class);
                    final Crosswalk crosswalk = crosswalkConstructor.newInstance(properties);
                    this.crosswalksMap.put(schemaLabel, crosswalk);
                }
                catch (Exception e) {
                    System.err.println("Crosswalks: couldn't construct: " + formatClassName);
                    e.printStackTrace();
                }
            }
        }
        if (this.crosswalksMap.size() == 0) {
            System.err.println("Crosswalks entries are missing from properties file");
        }
    }
    
    public String getMetadataPrefix(final String namespaceURI, final String schemaURL) {
        final String lookupValue = namespaceURI + " " + schemaURL;
        for (final Map.Entry entry : this.crosswalksMap.entrySet()) {
            if (entry.getValue().getSchemaLocation().equals(lookupValue)) {
                return entry.getKey();
            }
        }
        return null;
    }
    
    public String getSchemaURL(final String metadataPrefix) {
        final String schemaLocation = this.getSchemaLocation(metadataPrefix);
        final StringTokenizer tokenizer = new StringTokenizer(schemaLocation);
        tokenizer.nextToken();
        return tokenizer.nextToken();
    }
    
    public String getNamespaceURI(final String metadataPrefix) {
        final String schemaLocation = this.getSchemaLocation(metadataPrefix);
        final StringTokenizer tokenizer = new StringTokenizer(schemaLocation);
        return tokenizer.nextToken();
    }
    
    public String getSchemaLocation(final String metadataPrefix) {
        final Crosswalk crosswalk = this.crosswalksMap.get(metadataPrefix);
        if (crosswalk != null) {
            return crosswalk.getSchemaLocation();
        }
        return null;
    }
    
    public boolean containsValue(final String metadataPrefix) {
        return this.getCrosswalk(metadataPrefix) != null;
    }
    
    public Crosswalk getCrosswalk(final String metadataPrefix) {
        return this.crosswalksMap.get(metadataPrefix);
    }
    
    public Iterator iterator() {
        return this.crosswalksMap.entrySet().iterator();
    }
}
